clc;
close all;
%% Load healthy person lung sound file here
load posterior_right
Healthy_person_sound    = data(1:end);
fs      = 44100;                                                                    %% Sampling frequency
time    = linspace(0,length(data)/fs,length(data));                                 %% Signal time duration
%% Plot
figure
plot(time,Healthy_person_sound,'k');
xlabel('Time (s)','FontSize',12,'FontName','Times New Roman','fontweight','bold');
ylabel('Amplitude','FontSize',12,'FontName','Times New Roman','fontweight','bold');
set(gcf, 'Position',  [100, 300, 800, 300])
title('Healthy person lung sound','FontSize',12,'FontName','Times New Roman','fontweight','bold');